/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 * Copyright (C) 2012 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#include "ScreenSetStateCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

ScreenSetStateCommand::~ScreenSetStateCommand()
{
}

ExecutionResult ScreenSetStateCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    ExecutionResult result = ExecutionFailed;
    bool ret = false;
    //check if screen exist
    if (!scene.getScreen(m_screenID))
        return ExecutionFailed;

    LOG_DEBUG("ScreenSetStateCommand", "Screen = " << m_screenID << "state to be set to" << m_screenState);

    RendererList* rList;
    RendererListConstIterator it;

    rList = executor->getRendererList();
    result = ExecutionSuccess;
    for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
    {
    	ret = (*it)->SetDisplayState(m_screenID, (ilmScreenState)m_screenState);
    }
    if (ret)
    {
    	result = ExecutionSuccess;
    }
    return result;
}

const std::string ScreenSetStateCommand::getString()
{
    std::stringstream description;
    description << "ScreenSetStateCommand("
                << "m_screenID=" << m_screenID << "m_screenState=" << m_screenState;

    return description.str();
}
